<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--Preliminary XSL to convert setpath dag xml to setpath xml-->
      <xsl:output indent="yes"/>
      <xsl:strip-space elements="*"/>

      <xsl:template match="/expseq">
          <xsl:choose>
              <xsl:when test="./name[@data='setpath']">
                  <xsl:element name="setpath">
                      <xsl:apply-templates select="//string[@data]" mode="setpath_name"/>
                  </xsl:element>
              </xsl:when>
              <xsl:when test="./name[@data='display']">
                  <xsl:element name="display">
                       <xsl:apply-templates select="//equation/name[@data='topic']" mode="display_topic"/>
                       <xsl:apply-templates select="//equation/name[@data='section']" mode="display_section"/>
                  </xsl:element>
              </xsl:when>
              <xsl:when test="./name[@data='refresh']">
                  <xsl:element name="refresh"/>
              </xsl:when>
              <xsl:when test="//equation/name[@data='notice']">
                  <xsl:element name="license">
                       <xsl:call-template name="notice"/>
                       <xsl:call-template name="serial"/>
                  </xsl:element>
              </xsl:when>
              <xsl:when test="count(./string)=1">
                  <xsl:element name="logo">
                       <xsl:apply-templates select="//" mode="grablogo"/>
                  </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                  <xsl:element name="unknown"/>
              </xsl:otherwise>
          </xsl:choose>
      </xsl:template>

      <!--LOGO TEMPLATE-->
      <xsl:template match="//string[@data]" mode="grablogo">
           <xsl:attribute name="value">
                <xsl:value-of select="@data"/>
           </xsl:attribute>
      </xsl:template>

      <!--SET PATH TEMPLATE-->
      <xsl:template match="//string[@data]" mode="setpath_name">
           <xsl:element name="database">
                <xsl:attribute name="name">
                     <xsl:value-of select="@data"/>
                </xsl:attribute>
           </xsl:element>
      </xsl:template>

      <!--DISPLAY TEMPLATES-->
      <xsl:template match="//equation/name[@data='topic'][1]" mode="display_topic">
           <xsl:attribute name="topic">
                <xsl:value-of select="//equation/name[@data='topic']/../string/@data"/>
           </xsl:attribute>
      </xsl:template>

      <xsl:template match="//equation/name[@data='section'][1]" mode="display_section">
           <xsl:attribute name="section">
                <xsl:value-of select="//equation/name[@data='section']/../name[2]/@data"/>
           </xsl:attribute>
      </xsl:template>

      <!--LICENSE TEMPLATES-->
      <xsl:template match="//equation/name[@data='notice']" mode="notice" name="notice">
           <xsl:element name="notice">
                <xsl:attribute name="value">
                     <xsl:value-of select="//equation/name[@data='notice']/../string/@data"/>
                </xsl:attribute>
           </xsl:element>
      </xsl:template>

      <xsl:template match="//equation/name[@data='serial']" mode="serial" name="serial">
           <xsl:element name="serial">
                <xsl:attribute name="value">
                     <xsl:value-of select="//equation/name[@data='serial']/../string/@data"/>
                </xsl:attribute>
           </xsl:element>
      </xsl:template>

</xsl:stylesheet>
