<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<!-- 
     ===========================================================================

     Stylesheet for converting from an XML representation of a Maple 8 worksheet
     to a Maple 9 representation.

     =========================================================================== 
-->


<xsl:template match="/">
  <xsl:comment>This file is automatically generated.  Do not edit!</xsl:comment>
  <xsl:apply-templates/>
</xsl:template>


<!--
   Format worksheet.

   The worksheet consists of a header followed by the worksheet contents.
   The header contains two parts: 1) Version info, and 2) a style table.

   The top level worksheet component is a titleless section.  All child sections
   contain titles.  To simplify the interpretation of the worksheet, the Maple 9
   format requires explicit elements for the section title and contents.  

   Styles have been reworked for the Maple 9 format.  Several old-style attributes
   are supported to facilitate translation to and from older formats.
-->

<xsl:template match="worksheet">
  <Document
    <xsl:apply-templates select="version[1]" />
    <xsl:apply-templates select="style-table[1]" />
    <Contents>
      <xsl:apply-templates select="section[1]/*" />
    </Contents>
  </Document>
</xsl:template>


<!-- 
     ===========================================================================

                                  Worksheet Header

     =========================================================================== 
-->


<!--
  Formatting of version element.

  Change major version number to 6.
-->
<xsl:template match="version">
  <xsl:element name="Version">
    <xsl:attribute name="major">6</xsl:attribute>
    <xsl:attribute name="minor">0</xsl:attribute>
    <xsl:attribute name="platform">
      <xsl:value-of select="@platform" />
    </xsl:attribute>
  </xsl:element>
</xsl:template>


<xsl:template match="style-table">
  <Styles>
    <xsl:apply-templates />
  </Styles>
</xsl:template>


<!--
  Format Character Styles

  Suppress inherited or obsolete settings.
  Self and parent ID are retained to facilitate loading (not required for files
  saved in Maple 9).
-->

<xsl:template match="cstyle">
  <xsl:element name="Font">
    <xsl:if test = "not(@name='')" >
      <xsl:attribute name="name">
        <xsl:value-of select="@name" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@self=-1)" >
      <xsl:attribute name="self">
        <xsl:value-of select="@self" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@parent=-1)" >
      <xsl:attribute name="parent" >
        <xsl:value-of select="@parent" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@typeface='')" >
      <xsl:attribute name = "font-family" >
        <xsl:value-of select="@typeface" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "@pointsize-control='set'" >
      <xsl:attribute name = "font-size" >
        <xsl:value-of select = "@pointsize" />
      </xsl:attribute>
    </xsl:if>
    <xsl:choose>
      <xsl:when test = "@colour-valid='true'">
        <xsl:attribute name="foreground">[<xsl:value-of select="@red"/>, <xsl:value-of select="@green"/>, <xsl:value-of select="@blue" />]</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="foreground">[0,0,0]</xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test = "not(@bold='inherited')">
      <xsl:attribute name="bold" >
        <xsl:value-of select="@bold" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@italic='inherited')">
      <xsl:attribute name="italic" >
        <xsl:value-of select="@italic" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@underline='inherited')">
      <xsl:attribute name="underline" >
        <xsl:value-of select="@underline" />
      </xsl:attribute>
    </xsl:if>
  </xsl:element>

</xsl:template>


<!--
  Paragraph styles
-->
<xsl:template match="pstyle">
  <xsl:element name="Layout">
    <xsl:attribute name="name">
      <xsl:value-of select="@name" />
    </xsl:attribute>
    <xsl:if test = "not(@self=-1)" >
      <xsl:attribute name="self">
        <xsl:value-of select="@self" />
      </xsl:attribute>
    </xsl:if>
    <xsl:if test = "not(@parent=-1)" >
      <xsl:attribute name="parent" >
        <xsl:value-of select="@parent" />
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates />
  </xsl:element>
</xsl:template>

<!-- 
     ===========================================================================

                                  Worksheet Components

     =========================================================================== 
-->



<!--
  Formatting of a paragraph.

  The element para is mapped to paragraph.
  The attribute pstyle is mapped to style.

-->
<xsl:template match="para">
  <xsl:comment>match=para</xsl:comment>
  <xsl:element name = "Text-Field">
    <xsl:if test = "not(@bookmark='')"> 
      <xsl:attribute name="bookmark" >
        <xsl:value-of select="@bookmark" />
      </xsl:attribute>
    </xsl:if>
    <xsl:element name="Paragraph">
      <xsl:attribute name="style">
        <xsl:value-of select="@pstyle"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:element>
</xsl:template>


<xsl:template match="exchange/para">
 <Input>
 <xsl:comment>match=para</xsl:comment>
  <xsl:element name = "Text-Field">
    <xsl:if test = "not(@bookmark='')"> 
      <xsl:attribute name="bookmark" >
        <xsl:value-of select="@bookmark" />
      </xsl:attribute>
    </xsl:if>
    <xsl:element name="Paragraph">
      <xsl:attribute name="style">
        <xsl:value-of select="@pstyle"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:element>
  </Input>
</xsl:template>


<!-- 
  Formatting of a section.

  The first paragraph in a Maple 8 worksheet is actually the title.
  The section title and contents are clearly separated in Maple 9.

-->
<xsl:template match="section">
  <xsl:comment>match=section</xsl:comment>
  <Section>
    <Title>
      <xsl:apply-templates select="*[position()=1]" />
    </Title>
    <Contents>
      <xsl:apply-templates select="*[position()>1]" />
    </Contents>
  </Section>
</xsl:template>


<!--
  An exchange object should not be an immediate descendent of a section.
  If detected, insert an execution group.
-->
<xsl:template match="section/exchange">
  <xsl:comment>match=section/exchange</xsl:comment>
  <Group>
    <xsl:apply-templates />
  </Group>
</xsl:template>


<!--
  An exchange object must contain something executable.
  If not, drop the exchange element.
-->
<xsl:template match="exchange">
  <xsl:apply-templates />
</xsl:template>


<!--
  Execution group - map "group" to "Group"
-->
<xsl:template match="group">
  <xsl:comment>match=group</xsl:comment>
  <Group>
    <xsl:apply-templates />
  </Group>
</xsl:template>


<!--
  Text - map "text" to "Text"
         copy character style attribute
-->
<xsl:template match="text">
  <xsl:comment>match=text</xsl:comment>
  <xsl:element name="Text">
    <xsl:if test = "not(@cstyle='')">
      <xsl:attribute name="style">
        <xsl:value-of select="@cstyle" />
      </xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>


<!-- 
  mapletext - Map "mapletext" to "text"
              Copy character style attribute
              Exchange element should already be inserted when processing
              parent paragraph
-->
<xsl:template match="mapletext">
  <xsl:comment>match=mapletext</xsl:comment>
  <xsl:element name="Text">
    <xsl:attribute name="style">
      <xsl:value-of select="@cstyle" />
    </xsl:attribute>
    <xsl:apply-templates/>
  </xsl:element>
</xsl:template>


</xsl:stylesheet>

